/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import stanford.cs106.io.IOUtils;

public class SimpleClient
extends SimpleNetworking {
    public static final String ERROR_KEY = "Error:";

    private SimpleClient() {
    }

    public static String makeRequest(String host, Request request) throws IOException {
        if (!host.endsWith("/")) {
            host = String.valueOf(host) + "/";
        }
        if (request == null) {
            throw new NullPointerException("null request passed");
        }
        try {
            URL destination = new URL(String.valueOf(host) + request.toGetRequest());
            HttpURLConnection conn = (HttpURLConnection)destination.openConnection();
            conn.setRequestMethod("GET");
            String response = IOUtils.readEntireStream(conn.getInputStream());
            if (response.startsWith(ERROR_KEY)) {
                throw new IOException(response);
            }
            return response;
        }
        catch (ConnectException e) {
            throw new IOException("Unable to connect to the server. Did you start it?");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + host + request.toGetRequest());
        }
    }
}

